<?php
/**
 * WebEngine Lottery Plugin
 * https://webenginecms.org/
 * 
 * @version 2.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2017 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

$Lottery = new \Plugin\Lottery\Lottery();
$lotteryList = $Lottery->getLotteryList();

echo '<h2>Lottery List</h2>';
if(is_array($lotteryList)) {
	echo '<table class="table">';
		echo '<thead>';
			echo '<tr>';
				echo '<th>Id</th>';
				echo '<th>Initial Jackpot</th>';
				echo '<th>Start Date</th>';
				echo '<th>End Date</th>';
				echo '<th colspan="4">Numbers</th>';
				echo '<th></th>';
			echo '</tr>';
		echo '</thead>';
		echo '<tbody>';
		foreach($lotteryList as $lottery) {
			echo '<tr>';
				echo '<td style="color:#ff0000;font-weight:bold;">#'.$lottery['id'].'</td>';
				echo '<td>'.number_format($lottery['current_jackpot']).'</td>';
				echo '<td>'.$lottery['start_timestamp'].'</td>';
				echo '<td>'.$lottery['end_timestamp'].'</td>';
				echo '<td>'.($lottery['finished'] == 1 ? $lottery['number1'] : '?').'</td>';
				echo '<td>'.($lottery['finished'] == 1 ? $lottery['number2'] : '?').'</td>';
				echo '<td>'.($lottery['finished'] == 1 ? $lottery['number3'] : '?').'</td>';
				echo '<td>'.($lottery['finished'] == 1 ? $lottery['number4'] : '?').'</td>';
				echo '<td><a href="?module=lottery&page=status&lottery='.$lottery['id'].'" class="btn btn-default btn-xs">more info</a></td>';
			echo '</tr>';
		}
		echo '</tbody>';
	echo '</table>';
} else {
	message('warning', 'There are no lotteries.');
}
